
#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"
#include "ctrl/BOLTControls.h"

#include "BOLTFrm.h"
#include "ctrl/BOLTBackup.h"
#include "wx/statline.h"

enum {
	ID_BB_BROWSE=9879,
		ID_BB_BACKUP,
		ID_BB_RESTORE,
		ID_BB_FILEPATH
};

//IMPLEMENT_DYNAMIC_CLASS(BOLTBackup,wxDialog)
BEGIN_EVENT_TABLE(BOLTBackup,wxDialog)
EVT_BUTTON(ID_BB_BROWSE,BOLTBackup::OnBrowse)
EVT_BUTTON(ID_BB_RESTORE,BOLTBackup::OnRestore)
EVT_BUTTON(ID_BB_BACKUP,BOLTBackup::OnBackup)
EVT_TEXT(ID_BB_FILEPATH,BOLTBackup::OnPath)
END_EVENT_TABLE()

BOLTBackup::BOLTBackup(BOLTdb *db,wxWindow *parent):
	wxDialog(parent,-1,"Backup Manager",wxDefaultPosition)
{
	this->db=db;
	SetFont(parent->GetFont());

}

void BOLTBackup::OnBrowse(wxCommandEvent &event)
{
wxString tPath,tLabel;
if (isRestore)
{
	tPath=wxFileSelector("Choose the file you would like to restore from","","backup","bck","*.bck",wxFILE_MUST_EXIST|wxOPEN,this);
}
 else 
{
	 if (this->bReportsOnly)
	 {
	 tPath=wxFileSelector("Choose the file you would like to save your reports to","","reports","bck","*.bck",wxSAVE|wxOVERWRITE_PROMPT,this);
	 } else
	 {
	 tPath=wxFileSelector("Choose the file you would like to backup to","","backup","bck","*.bck",wxSAVE|wxOVERWRITE_PROMPT,this);
	 }
}
 if (!tPath.IsEmpty())
 { tFilePath->SetValue(tPath); }
}


void BOLTBackup::OnBackup(wxCommandEvent &event)
{
//	wxGetApp().config->SetPath("\");
	db->Flush();
	wxString tStr;
	wxString sqlDumpExec;
	myConfig *config=wxGetApp().config;
	config->SetPath("/");

	config->Read("Tools/mysqldump",&tStr);
	if (tStr.IsEmpty()) { 
	while (!wxFileExists(tStr))
		{
		if(wxMessageBox("Please locate the mysqldump.exe program","Not Found",wxOK|wxCANCEL|wxCENTRE,this)==wxCANCEL)
			{ return; }
		tStr=wxFileSelector("Where is the mysqldump.exe program ?",
						"/mysql/bin",
						"mysqldump", "exe","Executable|*.exe",wxFILE_MUST_EXIST,this);
		}	
	config->Write("Tools/mysqldump",tStr);
	}
	sqlDumpExec=tStr;

//	sqlDumpExec.Append(tStr);

	tStr.Printf(" --opt -u\"%s\" -p\"%s\" -P\"%s\" -h\"%s\" -r\"%s\" %s",BOLTDB_user.c_str(),BOLTDB_pass.c_str(),BOLTDB_port.c_str(),BOLTDB_host.c_str(),this->tFilePath->GetValue().c_str(),BOLTDB_database.c_str());
	sqlDumpExec.Append(tStr);

	if (bReportsOnly)
	{
		sqlDumpExec.Append(" reportTriggers reports reportLayouts reportParameters reportPictures reportQueries reportQueryLayouts storedReports quickpicks");
	}
	if (wxExecute(sqlDumpExec,TRUE)==0)
	{ wxMessageBox("Backup Complete","Backup Status",wxOK,this); }
	else
	{
		tStr.Printf("Backup Failed : %s",sqlDumpExec.c_str());
		wxMessageBox(tStr,"Backup Status",wxOK,this); 
	}
}

void BOLTBackup::OnRestore(wxCommandEvent &event)
{
	db->Flush();

	wxString tStr;
	wxString sqlDumpExec;
	myConfig *config=wxGetApp().config;
	config->SetPath("/");
	wxString sqlExec;
	
	config->Read("Tools/mysql",&tStr);
	if (tStr.IsEmpty())
	{
		//TODO - let the user find the mysql path
		while (!wxFileExists(tStr))
		{
		if(wxMessageBox("Please locate the mysql.exe program","Not Found",wxOK|wxCANCEL|wxCENTRE,this)==wxCANCEL)
			{ return; }
		tStr=wxFileSelector("Where is the mysql.exe program ?",
						"/mysql/bin",
						"mysql", "exe","Executable|*.exe",wxFILE_MUST_EXIST,this);
		}	
		config->Write("Tools/mysql",tStr);
//		LOG_ERROR("Cannot Determine the Installation Directory.\n You may need to reinstall the software.");
	}
//	sqlExec=tStr;

	sqlExec.Printf("\"%s\" -u\"%s\" -p\"%s\" -P\"%s\" -h\"%s\" -e\"source %s\" %s",tStr.c_str(),BOLTDB_user.c_str(),BOLTDB_pass.c_str(),BOLTDB_port.c_str(),BOLTDB_host.c_str(),this->tFilePath->GetValue().c_str(),BOLTDB_database.c_str());
//	sqlExec.Append(tStr);

	if (wxExecute(sqlExec,TRUE)==0)
	{
		db->Flush();
		wxMessageBox("Restore Complete","Backup Status",wxOK,this); 
	}
	else
	{
		tStr.Printf("Restore Failed : %s",sqlExec.c_str());
		wxMessageBox(tStr,"Restore Status",wxOK,this); 
	}


}

void BOLTBackup::OnPath(wxCommandEvent &event)
{
//TODO make sure path is valid
// TODO if isRestore - make sure that the file exists
}

void BOLTBackup::DoBackup()
{
	this->bReportsOnly=FALSE;
	this->isRestore=FALSE;
	wxBoxSizer *topSizer=new wxBoxSizer(wxVERTICAL);
	wxBoxSizer *hSizer;

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Backup To :"),0,wxALIGN_RIGHT|wxALL,5);
	hSizer->Add(this->tFilePath=new wxTextCtrl(this,-1,""),1,wxEXPAND|wxALL,5);
	tFilePath->Enable(FALSE);
	hSizer->Add(this->bBrowse=new wxButton(this,ID_BB_BROWSE,"&Browse..."),0,wxALIGN_LEFT|wxALL,5);

	topSizer->Add(hSizer,1,wxEXPAND|wxALL,5);
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(this->bBackup=new wxButton(this,ID_BB_BACKUP,"&Start Backup"),0,wxALIGN_CENTER|wxALL,5);
	hSizer->Add(new wxButton(this,wxID_OK,"&Done"),0,wxALIGN_CENTER|wxALL,5);
	topSizer->Add(hSizer,1,wxEXPAND|wxALL,5);
//	SetAutoLayout(TRUE);
	SetSizerAndFit(topSizer);
	topSizer->SetSizeHints( this );
	topSizer->Fit( this );

	Centre( wxBOTH );
	ShowModal();
	this->bBrowse->SetFocus();
}
void BOLTBackup::DoBackupReports()
{
	this->bReportsOnly=TRUE;
	this->isRestore=FALSE;
	wxBoxSizer *topSizer=new wxBoxSizer(wxVERTICAL);
	wxBoxSizer *hSizer;

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Backup Reports To :"),0,wxALIGN_RIGHT|wxALL,5);
	hSizer->Add(this->tFilePath=new wxTextCtrl(this,-1,""),1,wxEXPAND|wxALL,5);
	tFilePath->Enable(FALSE);
	hSizer->Add(this->bBrowse=new wxButton(this,ID_BB_BROWSE,"&Browse..."),0,wxALIGN_LEFT|wxALL,5);

	topSizer->Add(hSizer,1,wxEXPAND|wxALL,5);
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(this->bBackup=new wxButton(this,ID_BB_BACKUP,"&Start Backup"),0,wxALIGN_CENTER|wxALL,5);
	hSizer->Add(new wxButton(this,wxID_OK,"&Done"),0,wxALIGN_CENTER|wxALL,5);
	topSizer->Add(hSizer,1,wxEXPAND|wxALL,5);
//	SetAutoLayout(TRUE);
	SetSizerAndFit(topSizer);
	topSizer->SetSizeHints( this );
	topSizer->Fit( this );

	Centre( wxBOTH );
	ShowModal();
	this->bBrowse->SetFocus();
}
void BOLTBackup::DoRestore()
{
this->isRestore=TRUE;
	wxBoxSizer *topSizer=new wxBoxSizer(wxVERTICAL);
	wxBoxSizer *hSizer;

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Restore From :"),0,wxALIGN_RIGHT|wxALL,5);
	hSizer->Add(this->tFilePath=new wxTextCtrl(this,-1,""),1,wxEXPAND|wxALL,5);
	tFilePath->Enable(FALSE);
	hSizer->Add(this->bBrowse=new wxButton(this,ID_BB_BROWSE,"&Browse..."),0,wxALIGN_LEFT|wxALL,5);
	topSizer->Add(hSizer,1,wxEXPAND|wxALL,5);

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(this->bRestore=new wxButton(this,ID_BB_RESTORE,"&Restore"),0,wxALIGN_CENTER|wxALL,5);
	hSizer->Add(new wxButton(this,wxID_OK,"&Done"),0,wxALIGN_CENTER|wxALL,5);
	topSizer->Add(hSizer,1,wxEXPAND|wxALL,5);
//	SetAutoLayout(TRUE);
	SetSizerAndFit(topSizer);
	topSizer->SetSizeHints( this );
	topSizer->Fit( this );

	Centre( wxBOTH );
	ShowModal();
	this->bBrowse->SetFocus();
}

